package gov.va.genisis2.bo;

import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.genisis2.common.enums.CommonEnum;
import gov.va.genisis2.common.enums.EmailEnum;
import gov.va.genisis2.common.enums.WorkflowStatusEnum;
import gov.va.genisis2.model.Request;
import gov.va.genisis2.model.User;
import gov.va.genisis2.vo.EmailDetails;

/**
 * @author Getaneh Kassahun
 *
 */

@Component
public class VinciManagerEmailHelper {

	@Autowired
	GetEmailProperties getEmailProperties;

	String emailSender = StringUtils.EMPTY;

	public void vinciManagerEmailNotification(JSONObject json, String operation, int requestId, Request request, String comments, User requesterUser, List<User> admins, List<User> ddms) {

		if (StringUtils.equalsIgnoreCase(operation, WorkflowStatusEnum.SUBMITTED.getDesc())) {
			populateEmailDetailsForSubmit(json, requestId, request, requesterUser, admins, ddms);
		} else if (StringUtils.equalsIgnoreCase(operation, WorkflowStatusEnum.RETURNED.getDesc())) {
			populateEmailDetailsForReturned(json, requestId, request, comments, requesterUser, ddms, admins);
		} else if (StringUtils.equalsIgnoreCase(operation, WorkflowStatusEnum.DENIED.getDesc())) {
			populateEmailDetailsForDenied(json, requestId, request, comments, requesterUser, admins, ddms);
		} else if (StringUtils.equalsIgnoreCase(operation, WorkflowStatusEnum.REQUESTACCEPTED.getDesc())) {
			populateEmailDetailsForAccepted(json, requestId, request, comments, requesterUser, admins, ddms);
		} else if (StringUtils.equalsIgnoreCase(operation, WorkflowStatusEnum.RESULTSDELIVERED.getDesc())) {
			populateEmailDetailsForResultsDelivered(json, requestId, request, comments, requesterUser, admins, ddms);
		} else if (StringUtils.equalsIgnoreCase(operation, WorkflowStatusEnum.RESULTSNOTACCEPTED.getDesc())) {
			populateEmailDetailsForResultsNotAccepted(json, requestId, request, comments, requesterUser, admins, ddms);
		} else if (StringUtils.equalsIgnoreCase(operation, WorkflowStatusEnum.RESULTSACCEPTED.getDesc())) {
			populateEmailDetailsForResultsAccepted(json, requestId, request, comments, requesterUser, admins, ddms);
		} else if (StringUtils.equalsIgnoreCase(operation, WorkflowStatusEnum.CANCELLED.getDesc())) {
			populateEmailDetailsForCancelledRequest(json, requestId, request, requesterUser, admins, ddms);
		}

	}

	public void populateEmailDetailsForSubmit(JSONObject json, int requestId, Request request, User requesterUser, List<User> admins, List<User> ddms) {
		List<EmailDetails> emailDetails = new ArrayList<>();
		json.put(CommonEnum.EMAIL_APPROVER_DECISION.getText(), EmailEnum.EMPTY_STRING.getText());

		String emailRecipient = (null != requesterUser) ? requesterUser.getEmailId() : null;
		String emailSubject = getEmailProperties.getMessage(EmailEnum.VM_EMAIL_SUBJECT_SUBMIT.getText(), new Object[] { requestId, request.getTitle() });
		String emailBody = getEmailProperties.getMessage(EmailEnum.VM_EMAIL_BODY_SUBMIT.getText(), new Object[] { requestId, System.lineSeparator() });
		EmailDetails emailDet = new EmailDetails(emailSender, emailRecipients(emailRecipient, ddms, admins), removeCommaFromRequestID(emailSubject), removeCommaFromRequestID(emailBody), StringUtils.EMPTY);
		emailDetails.add(emailDet);
		json.put(CommonEnum.EMAIL_LIST.getText(), emailDetails);
	}

	public void populateEmailDetailsForReturned(JSONObject json, int requestId, Request request, String comments, User requesterUser, List<User> admins, List<User> ddms) {
		List<EmailDetails> emailDetails = new ArrayList<>();
		json.put(CommonEnum.EMAIL_APPROVER_DECISION.getText(), EmailEnum.RETURN_REQUEST.getText());

		String emailRecipient = (null != requesterUser) ? requesterUser.getEmailId() : null;
		String emailSubject = getEmailProperties.getMessage(EmailEnum.VM_EMAIL_SUBJECT_RETURNED.getText(), new Object[] { requestId, request.getTitle() });
		String emailBody = getEmailProperties.getMessage(EmailEnum.VM_EMAIL_BODY_RETURNED.getText(), new Object[] { requestId, System.lineSeparator() });
		emailBody = emailBody + System.lineSeparator() + CommonEnum.EMAIL_COMMENTS.getText() + comments;

		EmailDetails emailDet = new EmailDetails(emailSender, emailRecipients(emailRecipient, ddms, admins), removeCommaFromRequestID(emailSubject), removeCommaFromRequestID(emailBody), StringUtils.EMPTY);
		emailDetails.add(emailDet);

		json.put(CommonEnum.EMAIL_LIST.getText(), emailDetails);
	}

	public void populateEmailDetailsForDenied(JSONObject json, int requestId, Request request, String comments, User requesterUser, List<User> admins, List<User> ddms) {
		List<EmailDetails> emailDetails = new ArrayList<>();

		json.put(CommonEnum.EMAIL_APPROVER_DECISION.getText(), EmailEnum.REJECT_REQUEST.getText());

		String emailRecipient = (null != requesterUser) ? requesterUser.getEmailId() : null;
		String emailSubject = getEmailProperties.getMessage(EmailEnum.VM_EMAIL_SUBJECT_DENIED.getText(), new Object[] { requestId, request.getTitle() });
		String emailBody = getEmailProperties.getMessage(EmailEnum.VM_EMAIL_BODY_DENIED.getText(), new Object[] { requestId, System.lineSeparator() });
		emailBody = emailBody + System.lineSeparator() + CommonEnum.EMAIL_COMMENTS.getText() + comments;

		EmailDetails emailDet = new EmailDetails(emailSender, emailRecipients(emailRecipient, ddms, admins), removeCommaFromRequestID(emailSubject), removeCommaFromRequestID(emailBody), StringUtils.EMPTY);
		emailDetails.add(emailDet);

		json.put(CommonEnum.EMAIL_LIST.getText(), emailDetails);
	}

	public void populateEmailDetailsForAccepted(JSONObject json, int requestId, Request request, String comments, User requesterUser, List<User> admins, List<User> ddms) {
		List<EmailDetails> emailDetails = new ArrayList<>();

		json.put(CommonEnum.EMAIL_FULFILLMENT_DECISION.getText(), EmailEnum.FULFILLED_REQUEST.getText());
		json.put(EmailEnum.CC_USERS.getText(), EmailEnum.EMPTY_STRING.getText());

		String emailRecipient = (null != requesterUser) ? requesterUser.getEmailId() : null;
		String emailSubject = getEmailProperties.getMessage(EmailEnum.VM_EMAIL_SUBJECT_ACCEPTED.getText(), new Object[] { requestId, request.getTitle() });
		String emailBody = getEmailProperties.getMessage(EmailEnum.VM_EMAIL_BODY_ACCEPTED.getText(), new Object[] { requestId, System.lineSeparator() });
		emailBody = emailBody + System.lineSeparator() + CommonEnum.EMAIL_COMMENTS.getText() + comments;

		EmailDetails emailDet = new EmailDetails(emailSender, emailRecipients(emailRecipient, ddms, admins), removeCommaFromRequestID(emailSubject), removeCommaFromRequestID(emailBody), StringUtils.EMPTY);
		emailDetails.add(emailDet);
		json.put(CommonEnum.EMAIL_LIST.getText(), emailDetails);
	}

	public void populateEmailDetailsForResultsDelivered(JSONObject json, int requestId, Request request, String comments, User requesterUser, List<User> admins, List<User> ddms) {
		List<EmailDetails> emailDetails = new ArrayList<>();
		json.put(CommonEnum.EMAIL_RESULTS_DELIVER_DECISION.getText(), StringUtils.EMPTY);
		json.put(EmailEnum.CC_USERS.getText(), EmailEnum.VINCI_DATASOURCE.getText());

		String emailRecipient = (null != requesterUser) ? requesterUser.getEmailId() : null;
		String emailSubject = getEmailProperties.getMessage(EmailEnum.VM_EMAIL_SUBJECT_RESULTS_DELIVERED.getText(), new Object[] { requestId, request.getTitle() });
		String emailBody = getEmailProperties.getMessage(EmailEnum.VM_EMAIL_BODY_RESULTS_DELIVERED.getText(), new Object[] { requestId, System.lineSeparator() });
		emailBody = emailBody + System.lineSeparator() + CommonEnum.EMAIL_COMMENTS.getText() + comments;

		EmailDetails emailDet = new EmailDetails(emailSender, emailRecipients(emailRecipient, ddms, admins), removeCommaFromRequestID(emailSubject), removeCommaFromRequestID(emailBody), StringUtils.EMPTY);
		emailDetails.add(emailDet);

		json.put(CommonEnum.EMAIL_LIST.getText(), emailDetails);
	}

	public void populateEmailDetailsForResultsNotAccepted(JSONObject json, int requestId, Request request, String comments, User requesterUser, List<User> admins, List<User> ddms) {
		List<EmailDetails> emailDetails = new ArrayList<>();
		json.put(CommonEnum.EMAIL_RESULT_ACCEPTANCE_DECISION.getText(), EmailEnum.REJECT_REQUEST.getText());

		String emailRecipient = (null != requesterUser) ? requesterUser.getEmailId() : null;
		String emailSubject = getEmailProperties.getMessage(EmailEnum.VM_EMAIL_SUBJECT_RESULTS_NOT_ACCEPTED.getText(), new Object[] { requestId, request.getTitle() });
		String emailBody = getEmailProperties.getMessage(EmailEnum.VM_EMAIL_BODY_RESULTS_NOT_ACCEPTED.getText(), new Object[] { requestId, System.lineSeparator() });
		emailBody = emailBody + System.lineSeparator() + CommonEnum.EMAIL_COMMENTS.getText() + comments;

		EmailDetails emailDet = new EmailDetails(emailSender, emailRecipients(emailRecipient, ddms, admins), removeCommaFromRequestID(emailSubject), removeCommaFromRequestID(emailBody), StringUtils.EMPTY);
		emailDetails.add(emailDet);
		json.put(CommonEnum.EMAIL_LIST.getText(), emailDetails);
	}

	public void populateEmailDetailsForResultsAccepted(JSONObject json, int requestId, Request request, String comments, User requesterUser, List<User> admins, List<User> ddms) {
		List<EmailDetails> emailDetails = new ArrayList<>();
		json.put(CommonEnum.EMAIL_RESULT_ACCEPTANCE_DECISION.getText(), EmailEnum.FULFILLED_ACCEPT.getText());

		String emailRecipient = (null != requesterUser) ? requesterUser.getEmailId() : null;
		String emailSubject = getEmailProperties.getMessage(EmailEnum.VM_EMAIL_SUBJECT_RESULTS_ACCEPTED.getText(), new Object[] { requestId, request.getTitle() });
		String emailBody = getEmailProperties.getMessage(EmailEnum.VM_EMAIL_BODY_RESULTS_ACCEPTED.getText(), new Object[] { requestId, System.lineSeparator() });
		emailBody = emailBody + System.lineSeparator() + CommonEnum.EMAIL_COMMENTS.getText() + comments;

		EmailDetails emailDet = new EmailDetails(emailSender, emailRecipients(emailRecipient, ddms, admins), removeCommaFromRequestID(emailSubject), removeCommaFromRequestID(emailBody), StringUtils.EMPTY);
		emailDetails.add(emailDet);
		json.put(CommonEnum.EMAIL_LIST.getText(), emailDetails);
	}

	public void populateEmailDetailsForCancelledRequest(JSONObject json, int requestId, Request request, User requesterUser, List<User> admins, List<User> ddms) {
		List<EmailDetails> emailDetails = new ArrayList<>();

		String status = StringUtils.trim(request.getStatusDescription());
		if (StringUtils.equals(request.getStatusDescription(), WorkflowStatusEnum.SUBMITTED.getDesc())) {
			json.put(CommonEnum.EMAIL_APPROVER_DECISION.getText(), EmailEnum.CANCEL_REQUEST.getText());
			json.put(CommonEnum.EMAIL_FULFILLMENT_DECISION.getText(), StringUtils.EMPTY);
			json.put(CommonEnum.EMAIL_RESULTS_DELIVER_DECISION.getText(), StringUtils.EMPTY);
		}
		if (StringUtils.equalsIgnoreCase(status, WorkflowStatusEnum.RETURNED.getDesc())) {
			json.put(CommonEnum.EMAIL_APPROVER_DECISION.getText(), EmailEnum.CANCEL_REQUEST.getText());
			json.put(CommonEnum.EMAIL_RESULTS_DELIVER_DECISION.getText(), StringUtils.EMPTY);
			json.put(CommonEnum.EMAIL_FULFILLMENT_DECISION.getText(), StringUtils.EMPTY);
		}
		if (StringUtils.equalsIgnoreCase(status, WorkflowStatusEnum.REQUESTACCEPTED.getDesc())) {
			json.put(CommonEnum.EMAIL_RESULTS_DELIVER_DECISION.getText(), EmailEnum.CANCEL_REQUEST.getText());
			json.put(CommonEnum.EMAIL_APPROVER_DECISION.getText(), StringUtils.EMPTY);
			json.put(CommonEnum.EMAIL_FULFILLMENT_DECISION.getText(), StringUtils.EMPTY);
		}
		if (StringUtils.equalsIgnoreCase(status, WorkflowStatusEnum.RESULTSDELIVERED.getDesc())) {
			json.put(CommonEnum.EMAIL_RESULT_ACCEPTANCE_DECISION.getText(), EmailEnum.CANCEL_REQUEST.getText());
			json.put(CommonEnum.EMAIL_APPROVER_DECISION.getText(), StringUtils.EMPTY);
			json.put(CommonEnum.EMAIL_FULFILLMENT_DECISION.getText(), StringUtils.EMPTY);
		}

		String emailRecipient = (null != requesterUser) ? requesterUser.getEmailId() : null;
		String emailSubject = getEmailProperties.getMessage(EmailEnum.VM_EMAIL_SUBJECT_CANCELLED.getText(), new Object[] { requestId, request.getTitle() });
		String emailBody = getEmailProperties.getMessage(EmailEnum.VM_EMAIL_BODY_CANCELLED.getText(), new Object[] { requestId, System.lineSeparator() });

		EmailDetails emailDet = new EmailDetails(emailSender, emailRecipients(emailRecipient, ddms, admins), removeCommaFromRequestID(emailSubject), removeCommaFromRequestID(emailBody), StringUtils.EMPTY);
		emailDetails.add(emailDet);
		json.put(CommonEnum.EMAIL_LIST.getText(), emailDetails);
	}

	@SafeVarargs
	private final String extractEmailIds(String requesterEmail, List<User>... userList) {
		StringJoiner sj = new StringJoiner(EmailEnum.EMAILID_DELIMETER.getText());
		if (StringUtils.isNotBlank(requesterEmail)) {
			sj.add(requesterEmail);
		}
		if (null == userList || userList.length == 0) {
			return sj.toString();
		}
		for (List<User> users : userList) {
			if (null != users && !users.isEmpty()) {
				for (User user : users) {
					if (null != user && StringUtils.isNotBlank(user.getEmailId())) {
						sj.add(user.getEmailId());
					}
				}
			}
		}
		return sj.toString();
	}

	private String emailRecipients(String emailRecipient, List<User> admins, List<User> ddms) {
		return extractEmailIds(emailRecipient, ddms, admins);
	}

	private String removeCommaFromRequestID(String emailDetail) {
		String regex = "(?<=[\\d])(,)(?=[\\d])";
		Pattern p = Pattern.compile(regex);
		Matcher m = p.matcher(emailDetail);
		return m.replaceAll("");
	}
}
